import { useState, useEffect } from 'react'
import { motion, AnimatePresence } from 'framer-motion'
import { ChevronLeft, ChevronRight } from 'lucide-react'
import './ImageSlider.css'

const ImageSlider = () => {
  const [currentSlide, setCurrentSlide] = useState(0)
  const images = [
    '/images/dental-1.jpg',
    '/images/dental-2.jpg',
    '/images/dental-3.jpg',
    '/images/dental-4.jpg'
  ]

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentSlide((prev) => (prev + 1) % images.length)
    }, 3000)
    return () => clearInterval(interval)
  }, [images.length])

  const nextSlide = () => {
    setCurrentSlide((prev) => (prev + 1) % images.length)
  }

  const prevSlide = () => {
    setCurrentSlide((prev) => (prev - 1 + images.length) % images.length)
  }

  const goToSlide = (index) => {
    setCurrentSlide(index)
  }

  return (
    <div className="slider-container">
      <div className="slider-wrapper">
        <AnimatePresence mode="wait">
          {images.map((image, index) => (
            index === currentSlide && (
              <motion.div
                key={index}
                className="slide active"
                initial={{ opacity: 0, scale: 1.1 }}
                animate={{ opacity: 1, scale: 1 }}
                exit={{ opacity: 0, scale: 0.9 }}
                transition={{ duration: 0.8 }}
                style={{
                  backgroundImage: `url(${image})`,
                  backgroundSize: 'cover',
                  backgroundPosition: 'center'
                }}
              />
            )
          ))}
        </AnimatePresence>
      </div>
      <button className="slider-btn slider-btn-prev" onClick={prevSlide}>
        <ChevronLeft className="slider-icon" size={24} color="#0EA5E9" />
      </button>
      <button className="slider-btn slider-btn-next" onClick={nextSlide}>
        <ChevronRight className="slider-icon" size={24} color="#0EA5E9" />
      </button>
      <div className="slider-dots">
        {images.map((_, index) => (
          <button
            key={index}
            className={`dot ${index === currentSlide ? 'active' : ''}`}
            onClick={() => goToSlide(index)}
          />
        ))}
      </div>
    </div>
  )
}

export default ImageSlider

